# Copyright (C) 1999 Lucent Technologies
# Kod z ksiazki The Practice of Programming
# Briana W. Kernighana i Roba Pike'a

# markov.pl: algorytm łańcucha Markowa dla przedrostków dwuwyrazowych
$MAXGEN = 10000;
$NONWORD = "\n";
$w1 = $w2 = $NONWORD;           # Stan początkowy
while (<>) {                    # Wczytywanie wszystkich wierszy danych wejściowych
	foreach (split) {
		push(@{$statetab{$w1}{$w2}}, $_);
		($w1, $w2) = ($w2, $_);	# Wielokrotne przypisanie
	}
}
push(@{$statetab{$w1}{$w2}}, $NONWORD); 	# Dodanie ogona

$w1 = $w2 = $NONWORD;
for ($i = 0; $i < $MAXGEN; $i++) {
	$suf = $statetab{$w1}{$w2};	# Odwołanie do tablicy
	$r = int(rand @$suf);		# @$suf oznacza liczbę elementów
	exit if (($t = $suf->[$r]) eq $NONWORD);
	print "$t\n";
	($w1, $w2) = ($w2, $t);		# Aktualizacja łańcucha
}
